* Title: 	figure18.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of change in separated/divorced rate


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure18, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip PrimeMaleD MaritalI EmploymentI wtsupp ///
	using dta/asec_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (2) Construct rates for employment categories
*******************************************************************************

gen 	Sep_Divorced = (MaritalI == 3)
rename 	PrimeMaleD Total
foreach var in Sep_Divorced Total {
	gen `var'_Emp	= `var' if (EmploymentI == 0)
	gen `var'_ST	= `var' if (EmploymentI == 1)
	gen `var'_LT	= `var' if (EmploymentI == 2)
}
drop Sep_Divorced Total

collapse (sum) Total* Sep_Divorced* [pw=wtsupp], by(year)
	
tsset year
foreach emp in Emp ST LT {
	gen Sep_Divorced_Rate_`emp' = 100 * (L.Sep_Divorced_`emp' + Sep_Divorced_`emp' + F.Sep_Divorced_`emp') ///
								/ (L.Total_`emp' + Total_`emp' + F.Total_`emp')
}

keep year Sep_Divorced_Rate* 
keep if (year >= 1978 & year <= 2015)

* Save dataset
compress
save output/figures/dta/figure18.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

line 	Sep_Divorced_Rate_Emp Sep_Divorced_Rate_ST Sep_Divorced_Rate_LT year, ///
		legend(label(1 "Employed") label(2 "Short-term not working") label(3 "Long-term not working")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Year") ytitle("Share of men by employment status, percent")

graph save output/figures/gph/figure18, replace
graph export output/figures/eps/figure18.eps, as(eps) replace
export excel using output/figures/xlsx/figure18.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
